﻿using System.ServiceModel;
using BMS.VistaIntegration.HL7.DataContracts;

namespace BMS.VistaIntegration.HL7.ServiceContracts
{
    /// <summary>
    /// Contract for the service which receives HL7 notification messages from Vista through Mirth.
    /// </summary>
    [ServiceContract()]
    [XmlSerializerFormat]
    public interface IHL7Operations
    {
        /// <summary>
        /// Notifies the occurence of an ADT event (ADT A01, A02 or A03 events) or a new patient registering event (ADT A04 event).
        /// </summary>
        /// <param name="adtEvent">The ADT event.</param>
        [OperationContract(Action = "*", Name = "NotifyEvent")]
        [XmlSerializerFormat]
        void NotifyEvent(HL7Event hl7Event);
    }
}
